/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;

public class CardTrailEffect
extends AbstractGameEffect {
    private static final float EFFECT_DUR = 0.4f;
    private float x;
    private float y;
    private static TextureAtlas.AtlasRegion img = null;

    public CardTrailEffect(float x, float y, float angle) {
        if (img == null) {
            img = ImageMaster.vfxAtlas.findRegion("combat/blurDot");
        }
        this.renderBehind = false;
        this.duration = 0.4f;
        this.startingDuration = 0.4f;
        this.x = x - (float)CardTrailEffect.img.packedWidth / 2.0f;
        this.y = y - (float)CardTrailEffect.img.packedHeight / 2.0f;
        this.rotation = 0.0f;
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.color = new Color(1.0f, 0.4f, 0.1f, 1.0f);
                break;
            }
            case THE_SILENT: {
                this.color = Color.CHARTREUSE.cpy();
                break;
            }
            case CROWBOT: {
                this.color = Color.SKY.cpy();
                break;
            }
        }
        this.scale = 0.01f;
    }

    @Override
    public void update() {
        this.duration -= Gdx.graphics.getDeltaTime();
        this.scale = this.duration < 0.2f ? this.duration * Settings.scale * 11.0f : (this.duration - 0.2f) * Settings.scale * 11.0f;
        if (this.duration < 0.0f) {
            this.isDone = true;
        } else {
            this.color.a = Interpolation.fade.apply(0.0f, 0.15f, this.duration / 0.4f);
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setBlendFunction(770, 1);
        sb.setColor(this.color);
        sb.draw(img, this.x, this.y, (float)CardTrailEffect.img.packedWidth / 2.0f, (float)CardTrailEffect.img.packedHeight / 2.0f, CardTrailEffect.img.packedWidth, CardTrailEffect.img.packedHeight, this.scale, this.scale, this.rotation);
        sb.setBlendFunction(770, 771);
    }
}

